#declare simple_grey = texture {
    pigment {
        granite
        color_map {
            [0.0 rgb 0.3 ]
            [1.0 rgb 0.7 ]
        }
        scale 0.075
    }
    normal  { granite 0.75 scale 0.075 }
}
texture {
    pigment {
        wrinkles
        turbulence 0.3
        scale 0.3
        color_map {
            [0.0 rgbt< 0.50, 0.25, 0.10, 0.85>]
            [1.0 rgbt< 0.65, 0.40, 0.00, 0.65>]
        }
    }
}

#declare simple_white = texture {
    pigment {
        granite
        color_map {
            [0.0 rgb 0.85 ]
            [1.0 rgb 0.95 ]
        }
        scale 0.075
    }
    normal  { granite 0.75 scale 0.075 }
}
texture {
    pigment {
        wrinkles
        turbulence 0.3
        scale 0.3
        color_map {
            [0.0 rgbt< 0.80, 0.75, 0.60, 0.95>]
            [1.0 rgbt< 0.95, .85, 0.90, 0.95>]
        }
    }
}

#declare wall_texture = texture {
	//T_Stone3
	//T_Stone9
	//T_Stone17	//good white with grey veins
	//T_Stone35	//much rougher white marble
	simple_white
	scale 4
}

#declare floor_texture = texture {
	simple_grey
	scale 8
}

#declare ceiling_texture = texture {
	floor_texture
}

#declare pew = box{
	<0, 0, 0>, <.5, .5, 12>
	texture {
		T_Wood19
	}
}

#declare kneeler = box {
	<0, 0, 0>, <1.5, .75, 4>
	texture {
		T_Wood19
	}
}

//door
#declare verticalWood = texture {
	T_Wood19
	rotate <0, 90, 90>
}
#declare horizontalWood = texture {
	verticalWood
	rotate <0, 0, 90>
}

#declare door_side_width = door_width/5;
#declare door_other_side = door_width-door_side_width;
#declare center_width = door_width-2*door_side_width;
#declare center_height = door_height*2/10;
#declare door_handle_radius = door_side_width*(3/4)/2;
#declare handle_inner_radius = door_handle_radius/4;


#declare doorMiddleEighth = superellipsoid {
	< 0.25, 0.95 >
	translate <-1, 1, door_thickness>
	scale <center_width/2, center_height/2, door_thickness/2>
	scale <1, 1, 2>
	scale .5
}
#declare doorMiddleQuarter = union {
	object { doorMiddleEighth }
	object { doorMiddleEighth
		translate <-center_width/2, 0, 0>
	}
	object { doorMiddleEighth
		translate <-center_width/2, center_height/2, 0>
	}
	object { doorMiddleEighth
		translate <0, center_height/2, 0>
	}
	scale .5
}

#declare doorMiddle = union {
	box {
		<-center_width, 0, 0>, <0, center_height, door_thickness/4>
		texture {
			pigment {
				color rgb <.5, .7, .5>
			}
		}
	}
	object { doorMiddleQuarter }
	object { doorMiddleQuarter
		translate <-center_width/2, 0, 0>
	}
	object { doorMiddleQuarter
		translate <-center_width/2, center_height/2, 0>
	}
	object { doorMiddleQuarter
		translate <0, center_height/2, 0>
	}
	translate <-door_side_width, 0, 0>
	texture {
		pigment {
			color rgb <.3, .6, .3>
		}
	}
}

#declare doorPlate = cylinder {
	<0, 0, -handle_inner_radius*.2>, <0, 0, 0>
	door_handle_radius
	scale <.5, 1.5, 1>
	texture { T_Brass_1A }	
	translate <door_handle_radius+handle_inner_radius, 0, -handle_inner_radius>
}

#declare doorHandle = union {
	//the handle
	torus {
		door_handle_radius, handle_inner_radius
		rotate <90, 0, 0>
		scale <.9, 1, 1>
		texture { T_Brass_2A }
	}
	//the hinge of the handle
	cylinder {
		<-handle_inner_radius, door_handle_radius, 0>,
		<handle_inner_radius, door_handle_radius, 0>,
		handle_inner_radius*1.4
	}
	//the plate
	cylinder {
		<0, 0, -handle_inner_radius*.2>, <0, 0, 0>
		door_handle_radius
		scale <.5, 1.5, 1>
	}
	texture { T_Brass_1A }	
	translate <door_handle_radius+handle_inner_radius, 0, -handle_inner_radius>
}

#declare door = union {
	//tall sides
	box {
		<0, 0, 0>, <-door_side_width, door_height, door_thickness>
		texture { verticalWood }
	}

	box {
		<-door_other_side, 0, 0>, <-door_width, door_height, door_thickness>
		texture { verticalWood }
	}

	//middle part
	box {
		<-door_side_width, door_height*9/10, 0>,
		<-door_other_side, door_height, door_thickness>
		texture { horizontalWood }
	}
	
	object { doorMiddle
		translate <0, door_height*7/10, 0>
	}

	box {
		<-door_side_width, door_height*6/10, 0>,
		<-door_other_side, door_height*7/10, door_thickness>
		texture { horizontalWood }
	}

	object { doorMiddle
		translate <0, door_height*4/10, 0>
	}

	box {
		<-door_side_width, door_height*3/10, 0>,
		<-door_other_side, door_height*4/10, door_thickness>
		texture { horizontalWood }
	}

	object { doorMiddle
		translate <0, door_height*1/10, 0>
	}

	box {
		<-door_side_width, 0, 0>,
		<-door_other_side, door_height*1/10, door_thickness>
		texture { horizontalWood }
	}
	
}

#declare doorWithPlate = union {
	object { door }
	object { doorPlate
		translate <-door_width, door_height*3/5, 0>
	}
	object { doorPlate
		scale <1, 1, -1>
		translate <-door_width, door_height*3/5, door_thickness>
	}
}

#declare doorWithHandle = union {
	object { door }
	object { doorHandle
		translate <-door_width, door_height*3/5, 0>
	}
	object { doorPlate
		scale <1, 1, -1>
		translate <-door_width, door_height*3/5, door_thickness>
	}
}

//#declare carving_Size = <2.8, 2.8, .02>;
#declare carving_Size = <2.8, 2.8, .2>;
#declare carving_Ratio = 1800/1029;
#declare carving_Location = <-.019, 1.2, 2.8/2+2>;

#declare woodcarving = box {//height_field {
	//png "keys.png"
	<0, 0, 0>, <1, 1, 1>
	texture {
		pigment {
			image_map {
				png "keysalpha32.png"
				map_type 0	//planar
				interpolate 0	//none
			}
		}
	}
	scale <-1, carving_Ratio, 1>
	translate <1, 0, 0>
	scale carving_Size
	rotate <0, 90, 0>
	translate carving_Location - .4*x
}


#declare torchSet = union {
	union {
		object { torchSconce	}
		difference {
			cone {
				<0, 0, 0>, .075,
				<0, .3, 0>, .10
			}
			cone {
				<0, -.001, 0>, .07
				<0, .301, 0>, .095
			}
	
			//punch some holes into the sconce
			#declare holecount = 3;
			#declare levelcount = 4;
			#declare currentLevel = 0;
			#while (currentLevel < levelcount)
				#declare currentHole = 0;
				#while (currentHole  < holecount)
					cylinder {
						<-.15, 0, 0>, <.15, 0, 0>, .03
						rotate <0, 180*currentHole/holecount, 0>
						translate <0, .06+currentLevel*.06, 0>
						rotate <0, 90*currentLevel/levelcount, 0>
					}
					#declare currentHole = currentHole +1;
				#end
				#declare currentLevel = currentLevel + 1;
			#end
	
			rotate <4, 0, 0>
			translate <0, -.6, 0>
			texture { rustedCopper
				scale .02
			}
		}
		rotate <-20, 0, 2>
	}
	union {
		cylinder {
			<0, 0, -0.02>, <0, 0, 0.15>, .03
		}
		cylinder {
			<0, 0, 0.125>, <0, 0, 0.16>, .175
//			<0, 0, 0>, <0, 0, 0.16>, .18
		}
		translate <0, -.4, .25>
		texture { rustedCopper
			scale .02
		}
	}
//	translate <0, ceiling_height*.85, -.4>
	translate <0, ceiling_height*.815, -.4>
}
//#declare torch_X = 2.5;
#declare torch_X = 2.3;



#declare stoneTexCount = 20;
#declare stones = array[stoneTexCount]
	{
		T_Stone3, T_Stone9, T_Stone17, T_Stone35
		T_Stone5, T_Stone1, T_Stone31, T_Stone40,
		T_Stone4, T_Stone6, T_Stone11, T_Stone12,
		T_Stone16, T_Stone18, T_Stone21, T_Stone23,
		T_Stone24, T_Stone37, T_Stone43, T_Stone29
	}

#macro stonewall (wWidth, wHeight)
	#local stoneWidth = .8;
	#local stoneHeight = .5;
	#local stonePaddingH = .4;
	#local stonePaddingV = .25;
	
	#local stoneCountH = floor((wWidth+stonePaddingH)/(stoneWidth+stonePaddingH));
	#local stoneSidesH = ((wWidth+stonePaddingH)-stoneCountH*(stoneWidth+stonePaddingH))/2;
	#local stoneCountV = floor((wHeight+stonePaddingV)/(stoneHeight+stonePaddingV));
	#local stoneSidesV = ((wHeight+stonePaddingV)-stoneCountV*(stoneHeight+stonePaddingV))/2;
	
	#local mySeed = seed(616);
	#local theTexture = -1;
	union {
		#local currentRow = 0;
		#while (currentRow < stoneCountV)
			#local currentStone = 0;
			#local oddRow = currentRow - 2*floor(currentRow/2);
			#while ((currentStone < stoneCountH) | (oddRow = 1 & currentStone < stoneCountH+1))
				superellipsoid {
					<.2, .2>
					translate <1, 1, 0>
					#local widthMod = 0;
					#local hMod = 0;
					#if (oddRow = 1)
						#if (currentStone = 0 | currentStone = stoneCountH)
							#local widthMod = -stoneWidth/2 - stonePaddingH/2;
						#end
						#if (currentStone > 0)
							#local hMod = -stoneWidth/2 - stonePaddingH/2;
						#end
					#end
					scale <stoneWidth+widthMod, stoneHeight, .04>/2
					translate <stoneSidesH, stoneSidesV, -.02>
					translate <(stoneWidth+stonePaddingH)*currentStone+hMod, 0, 0>
					translate <0, (stoneHeight+stonePaddingV)*currentRow, 0>
					#declare theTexture = floor(rand(mySeed)*stoneTexCount);
					//#declare theTexture = theTexture + 1;
					//#if (theTexture >= stoneTexCount)
					//	#declare theTexture = 0;
					//#end
					texture {stones[theTexture]}
				}
				#declare currentStone = currentStone + 1;
			#end
			#declare currentRow = currentRow + 1;
		#end
	}	
#end

#include "skeleton.inc"

#macro center(theObject)
	#declare theMax = max_extent(theObject);
	#declare theMin = min_extent(theObject);
	
	#declare theMiddle = (theMax + theMin)/2;
	
	object { theObject
		translate -theMiddle
	}
#end


#declare torsoSize = (max_extent(sk_Torso) - min_extent(sk_Torso));

#declare jumbledBones = union {
	object { center(sk_Head)
		rotate <-30, 0, 0>
		rotate <0, -50, 0>
		translate <0, torsoSize.y/8, torsoSize.y/1.5>
	}
	object { center(sk_Torso)
		rotate <45, 0, 0>
	}
	rotate <0, -90, 0>
	scale 10
	
	texture {
		pigment {
			color White
		}
		
		normal {
			bumps .5
		}
		
		finish {
			diffuse .5
		}
	}
}

